﻿  package{
	  import flash.display.*;
	  import flash.text.TextField;	  
	  import flash.text.TextFormat;
	  import flash.text.TextFormatAlign;
	  import flash.events.*;
	  import flash.geom.Rectangle;
	  import flash.geom.Point;
	  import flash.net.*;
	  
	  public class DialogItemEdit extends MovieClip{
		  
		  public var flag_hasStageEvent = false;	//if stage event found or not
		  public var noDragFlag:Boolean = false;
		  public var itemID:String = "";
		  
		  //inner elements:
		  //
		  //txt_caption
		  //input_name
		  //input_desc
		  //mc_buttonCancel
		  //mc_buttonUpdate
		  //mc_buttonClose
		  
		  //constructor
		  public function DialogItemEdit(){
 			  this.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown_handler);
			  
			  this.txt_caption.mouseEnabled = false;
			  
			  CommonFunctions.initSimpleButton(this.mc_buttonCancel);
			  CommonFunctions.initSimpleButton(this.mc_buttonUpdate);
			  CommonFunctions.initSimpleButton(this.mc_buttonClose);
			  CommonFunctions.initSimpleButton(this.mc_buttonCheck);
			  
			  this.mc_buttonCancel.addEventListener(MouseEvent.CLICK,onButtonCancelClick);
			  this.mc_buttonCancel.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  this.mc_buttonUpdate.addEventListener(MouseEvent.CLICK,onButtonUpdateClick);
			  this.mc_buttonUpdate.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  this.mc_buttonClose.addEventListener(MouseEvent.CLICK,onButtonCancelClick);
			  this.mc_buttonClose.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);

			  this.mc_buttonCheck.addEventListener(MouseEvent.CLICK,onButtonCheckClick);
			  this.mc_buttonCheck.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);

			  //all buttons mouse down event
			  this.input_name.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  this.input_desc.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  this.input_link.addEventListener(MouseEvent.MOUSE_DOWN,onButtonsMouseDown);
			  
			  //keyboard events
			  this.input_name.addEventListener(KeyboardEvent.KEY_DOWN,onInputNameKeyDown);
			  this.input_desc.addEventListener(KeyboardEvent.KEY_DOWN,onInputDescKeyDown);
			  this.input_link.addEventListener(KeyboardEvent.KEY_DOWN,onInputNameKeyDown);
		  }
		  		  
	      //-------------------------------------------------------------------------
		  // input box key down. exit edit mode, and save name
		  public function onInputNameKeyDown(event:KeyboardEvent){
			  switch(event.keyCode){
				  case 13:	//enter - update item and close dialog
				  	updateItem();
					hide();
				  break;
				  case 27:	//escape - close the dialog without updating
				  	hide();
				  break;
			  }
		  }
		  
		  //------------------------------------------------------------------
		  // descripttion keyboard down event. if esc clicked - hide the dialog
		  public function onInputDescKeyDown(event:KeyboardEvent){
			  switch(event.keyCode){
				  case 27:
				  	hide();
				  break;
			  }
		  }		  
		  
		  //------------------------------------------------------------------
		  // position the dialog to parent center
		  public function positionParentCenter(){			  	
			  	var website = this.parent;
				if(website == null) return(false);
				var centerPoint:Point = website.centerPoint;			
				
				this.x = centerPoint.x - Math.floor((this.width)/2);				
				this.y = centerPoint.y - Math.floor((this.height)/2)-50;
		  }
		  
		  //------------------------------------------------------------------
		  // mouse down handler. start drag the dialog.
		  private function mouseDown_handler(event:MouseEvent){
			  if(this.noDragFlag == true){
				  this.noDragFlag = false;
				  return(false);
			  }
			  
			  if(this.flag_hasStageEvent == false){		//add once stage mouseup event
				  stage.addEventListener(MouseEvent.MOUSE_UP,stageMouseUp_handler);
				  this.flag_hasStageEvent = true;
			  }			  
			  var website = this.parent;			  			  
			  if(website == null) this.startDrag(false);
			  else{		//bound the drag area of the dialog to the parent.
			  	var rect1:Rectangle = website.boundRect;
			  	var rect:Rectangle = new Rectangle(rect1.x,rect1.y,rect1.width-this.width,rect1.height-this.height);
				this.startDrag(false,rect);
			  }
		  }
		  
		  //------------------------------------------------------------------
		  //stage mouse up handler. stop dragging
		  private function stageMouseUp_handler(event:MouseEvent){
			  this.stopDrag();
		  }
		  
		  //------------------------------------------------------------------
		  //event on button mouse down. stop the dragging.
		  public function onButtonsMouseDown(event:MouseEvent){
			  this.noDragFlag = true;
		  }
		  		  
		  //------------------------------------------------------------------
		  //event on button ok click. hide the dialog, and move the parent ok event.
		  public function onButtonCancelClick(event:MouseEvent){
				hide();
		  }
		  
		  //------------------------------------------------------------------
		  //eventon button check link click. open link in a new window
		  public function onButtonCheckClick(event:MouseEvent){
			  var url = this.input_link.text;
			  var req:URLRequest = new URLRequest(url);
			  navigateToURL(req,"_blank");
		  }
		  
		  //------------------------------------------------------------------
		  // move to the website update event.
		  public function updateItem(){
			  var website = this.parent;
			  website.updateEditPanelItem(this.itemID,this.input_name.text,this.input_desc.text,input_link.text);
			  website.updateItem(this.itemID,this.input_name.text,this.input_desc.text,input_link.text);
		  }
		  
		  //------------------------------------------------------------------
		  //event on button cancel click. hide the button
		  public function onButtonUpdateClick(event:MouseEvent){
			  updateItem();
			  hide();
		  }
		  
		  //------------------------------------------------------------------
		  //show the dialog with text
		  public function show(itemID:String,itemName:String,itemDesc:String,itemLink:String){			  			  
			  this.itemID = itemID;
			  this.txt_caption.text = itemName;
			  this.input_name.text = itemName;
			  this.input_desc.text = itemDesc;			  
			  this.input_link.text = itemLink;
			  this.input_desc.setFocus();
			  positionParentCenter();
			  this.visible = true;			  			  			  
		  }
		  
		  //------------------------------------------------------------------
		  //hide the dialog
		  public function hide(){
			  this.visible = false;
		  }
	  }   
  }